<?php

/**

 * GeneratePress.

 *

 * Please do not make any edits to this file. All edits should be done in a child theme.

 *

 * @package GeneratePress

 */



if ( ! defined( 'ABSPATH' ) ) {

	exit; // Exit if accessed directly.

}



// Set our theme version.

define( 'GENERATE_VERSION', '3.0.4' );



if ( ! function_exists( 'generate_setup' ) ) {

	add_action( 'after_setup_theme', 'generate_setup' );

	/**

	 * Sets up theme defaults and registers support for various WordPress features.

	 *

	 * @since 0.1

	 */

	function generate_setup() {

		// Make theme available for translation.

		load_theme_textdomain( 'generatepress' );



		// Add theme support for various features.

		add_theme_support( 'automatic-feed-links' );

		add_theme_support( 'post-thumbnails' );

		add_theme_support( 'post-formats', array( 'aside', 'image', 'video', 'quote', 'link', 'status' ) );

		add_theme_support( 'woocommerce' );

		add_theme_support( 'title-tag' );

		add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption', 'script', 'style' ) );

		add_theme_support( 'customize-selective-refresh-widgets' );

		add_theme_support( 'align-wide' );

		add_theme_support( 'responsive-embeds' );



		add_theme_support(

			'custom-logo',

			array(

				'height' => 70,

				'width' => 350,

				'flex-height' => true,

				'flex-width' => true,

			)

		);



		// Register primary menu.

		register_nav_menus(

			array(

				'primary' => __( 'Primary Menu', 'generatepress' ),

			)

		);



		/**

		 * Set the content width to something large

		 * We set a more accurate width in generate_smart_content_width()

		 */

		global $content_width;

		if ( ! isset( $content_width ) ) {

			$content_width = 1200; /* pixels */

		}



		// This theme styles the visual editor to resemble the theme style.

		add_editor_style( 'assets/css/admin/editor-style.css' );

	}

}



/**

 * Get all necessary theme files

 */

$theme_dir = get_template_directory();



require $theme_dir . '/inc/theme-functions.php';

require $theme_dir . '/inc/defaults.php';

require $theme_dir . '/inc/class-css.php';

require $theme_dir . '/inc/css-output.php';

require $theme_dir . '/inc/general.php';

require $theme_dir . '/inc/customizer.php';

require $theme_dir . '/inc/markup.php';

require $theme_dir . '/inc/typography.php';

require $theme_dir . '/inc/plugin-compat.php';

require $theme_dir . '/inc/block-editor.php';

require $theme_dir . '/inc/class-theme-update.php';

require $theme_dir . '/inc/deprecated.php';



if ( is_admin() ) {

	require $theme_dir . '/inc/meta-box.php';

	require $theme_dir . '/inc/dashboard.php';

}



/**

 * Load our theme structure

 */

require $theme_dir . '/inc/structure/archives.php';

require $theme_dir . '/inc/structure/comments.php';

require $theme_dir . '/inc/structure/featured-images.php';

require $theme_dir . '/inc/structure/footer.php';

require $theme_dir . '/inc/structure/header.php';

require $theme_dir . '/inc/structure/navigation.php';

require $theme_dir . '/inc/structure/post-meta.php';

require $theme_dir . '/inc/structure/sidebars.php';







add_action('woocommerce_after_shop_loop_item_title', 'display_custom_product_attributes_on_loop', 5 );

function display_custom_product_attributes_on_loop() {

    global $product;



    $value1 = $product->get_attribute('szin');



    if ( ! empty($value1) ) {



        echo '<div class="color-pre"><p>';



        $attributes = array();

        if ( ! empty($value1) ) {

            $attributes[] = $value1;

        }

        

        $pieces = explode(", ", $attributes[0]);

        foreach( $pieces as $piece ) {

            if($piece == 'Ezüst') {

                $class = 'Ezust';

            } else {

                $class = $piece;

            }

            echo '<span class='.$class.'>'.$piece.'</span>';

        }

        

        echo '</p></div>';

    }

}

// Add a custom fee (fixed or based cart subtotal percentage) by payment
add_action( 'woocommerce_cart_calculate_fees', 'custom_handling_fee' );
function custom_handling_fee ( $cart ) {
    if ( is_admin() && ! defined( 'DOING_AJAX' ) )
        return;

    $chosen_payment_id = WC()->session->get('chosen_payment_method');

    if ( empty( $chosen_payment_id ) )
        return;

    $subtotal = $cart->subtotal;

    // SETTINGS: Here set in the array the (payment Id) / (fee cost) pairs
    $targeted_payment_ids = array(
        'cod' => 1000
    );

    // Loop through defined payment Ids array
    foreach ( $targeted_payment_ids as $payment_id => $fee_cost ) {
        if ( $chosen_payment_id === $payment_id ) {
            $cart->add_fee( __('Kezelési költség', 'woocommerce'), $fee_cost, true );
        }
    }
}

// jQuery - Update checkout on payment method change
add_action( 'woocommerce_checkout_init', 'payment_methods_refresh_checkout' );
function payment_methods_refresh_checkout() {
    wc_enqueue_js( "jQuery( function($){
        $('form.checkout').on('change', 'input[name=payment_method]', function(){
            $(document.body).trigger('update_checkout');
        });
    });");
}

function my_hide_shipping_when_free_is_available( $rates ) {
	$free = array();
	foreach ( $rates as $rate_id => $rate ) {
		if ( 'free_shipping' === $rate->method_id ) {
			$free[ $rate_id ] = $rate;
			break;
		}
	}
	return ! empty( $free ) ? $free : $rates;
}
add_filter( 'woocommerce_package_rates', 'my_hide_shipping_when_free_is_available', 100 );